/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import java.util.List;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;

@Beta
public interface CqnHierarchySubsetTransformation extends CqnTransformation {

	/**
	 * Returns a reference, which identifies the entities that form a recursive
	 * hierarchy. The entity is annotated with {@code RecursiveHierarchy} with a
	 * qualifier whose value is given by the {@link #hierarchyQualifier()} method.
	 * 
	 * @return a reference, which identifies the entities that form a recursive
	 *         hierarchy
	 */
	CqnStructuredTypeRef hierarchyReference();

	/**
	 * Returns the qualifier of the {@code RecursiveHierarchy} annotation
	 * 
	 * @return the hierarchy qualifier
	 */
	String hierarchyQualifier();

	/**
	 * Returns a reference to the property that identifies the nodes of the
	 * hierarchy.
	 * 
	 * @return a reference to the node property
	 */
	CqnElementRef nodeProperty();

	/**
	 * Returns the transformations, which are applied to the input set before the
	 * ancestors/descendants are determined.
	 * 
	 * Typically, a {@link CqnFilterTransformation filter} or a
	 * {@link CqnSearchTransformation search} transformation is applied.
	 * 
	 * @return the transformations
	 */
	List<CqnTransformation> transformations();

	/**
	 * Returns the maximum distance between start nodes and ancestors or descendants
	 * 
	 * @return the maximum distance between start nodes and ancestors or descendants
	 */
	int distanceFromStart();

	/**
	 * Returns whether the start nodes, i.e. the nodes after applying the
	 * {@link #transformations() transformations}, should be included
	 * 
	 * @return {@code true}, if the start nodes should be include; {@code false},
	 *         otherwise
	 */
	boolean keepStart();
}
