/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;

/**
 * A transformation that is applied to the input set to produce an output set.
 */
@Beta
public interface CqnTransformation {

	enum Kind {
		IDENTITY, FILTER, SEARCH, AGGREGATE, COMPUTE, GROUPBY, ORDERBY, SKIP, TOP, CUSTOM, ANCESTORS, DESCENDANTS,
		TOPLEVELS;
	}

	/**
	 * Returns the kind of this transformation
	 * 
	 * @return the kind of this transformation
	 */
	Kind kind();

	CqnTransformation IDENTITY = new CqnTransformation() {

		@Override
		public Kind kind() {
			return Kind.IDENTITY;
		}

	};

}
