/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

public interface CdsStringType extends CdsSimpleType {

	static final String LENGTH = "length";

	/**
	 * Returns {@code true} if this {@code CdsString} is localized.
	 * 
	 * @return {@code true} if this String type is localized, otherwise
	 *         {@code false}
	 */
	boolean isLocalized();

	/**
	 * Returns the length of this {@code CdsString}. The default is 5000.
	 * 
	 * @return the length of this String type, not {@code null}
	 */
	default Integer getLength() {
		return get(LENGTH);
	}

	@Override
	default CdsBaseType getType() {
		return CdsBaseType.STRING;
	}

	@Override
	default Class<?> getJavaType() {
		return String.class;
	}

}
