/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

import com.google.common.annotations.Beta;

@Beta
public interface CdsVector {

  Factory factory = Cds4jServiceLoader.load(Factory.class);

  /**
   * Returns a new {@link CdsVector}.
   *
   * @param vector the vector as float[]
   * @return a new {@link CdsVector}
   */
  static CdsVector of(float[] vector) {
    return factory.of(vector);
  }

  /**
   * Returns a new {@link CdsVector}.
   *
   * @param vector in String format "[0.42, -0.73, ...]"
   * @return a new {@link CdsVector}
   */
  static CdsVector of(String vector) {
    return factory.of(vector);
  }

  /**
   * Returns the float[] representation of this vector.
   *
   * @return the float[] representation of this vector
   */
  float[] floats();

  /**
   * Returns the dimension of the vector space this vector is embedded in.
   *
   * @return the dimension of the vector space
   */
  int dimension();

  /**
   * Returns the String representation of this vector.
   *
   * @return the string representation of this vector
   */
  @Override
  String toString();

  interface Factory {
    CdsVector of(Object vector);
  }
}
