/*
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.connector;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import java.sql.Connection;
import java.util.function.Supplier;
import javax.sql.DataSource;

/** Builder interface to programmatically create a {@link CdsDataStoreConnector}. */
@Beta
public interface CdsDataStoreConnectorBuilder {

  /**
   * Set the data source
   *
   * @param datasource the data source
   * @return this builder
   */
  CdsDataStoreConnectorBuilder datasource(DataSource datasource);

  /**
   * Set the connection supplier
   *
   * @param connectionSupplier the connection supplier
   * @return this builder
   */
  CdsDataStoreConnectorBuilder connection(Supplier<Connection> connectionSupplier);

  /**
   * Set the data store configuration
   *
   * @param dataStoreConfiguration the data store configuration
   * @return this builder
   */
  CdsDataStoreConnectorBuilder config(DataStoreConfiguration dataStoreConfiguration);

  /**
   * Build the {@link CdsDataStoreConnector}
   *
   * @return the {@link CdsDataStoreConnector} object
   */
  CdsDataStoreConnector build();
}
