/*
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.connector;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.transaction.TransactionManager;

/** Factory interface to create {@link CdsDataStoreConnectorBuilder} */
public interface CdsDataStoreConnectorFactory {

  /**
   * Creates a {@link CdsDataStoreConnectorBuilder} instance
   *
   * @param cdsModel the CDS Model
   * @param transactionManager the transaction manager
   * @return instance of {@link CdsDataStoreConnectorBuilder}
   */
  CdsDataStoreConnectorBuilder create(CdsModel cdsModel, TransactionManager transactionManager);
}
