/*
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

/**
 * An entity that can be searched for a search term or to which a search expression can be applied.
 */
public interface Searchable {

  /**
   * Build a predicate to check, whether searchable matches a given search term.
   *
   * @param searchTerm the search term
   * @return the predicate for the containment test
   */
  Predicate has(String searchTerm);
}
