/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnValue;

/** Represents a value that can be selected in a query. */
public interface SelectableValue extends CqnValue {

  /**
   * Assigns an alias to this value under which this value can be referenced in the query result.
   *
   * @param alias the alias to assign
   * @return a {@link CqnSelectListValue} with the assigned alias
   */
  CqnSelectListValue as(String alias);

  @Deprecated(since = "3.7", forRemoval = true)
  CqnSelectListValue withoutAlias();
}
