/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnCaseExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;

public interface Then {

  /**
   * Connects a next {@link CqnCaseExpression.Case case}) to a chain of when-then expressions.
   *
   * @param pred the {@link CqnCaseExpression.Case#condition() condition} of the next case.
   * @return a builder to specify the case's return value
   */
  When when(CqnPredicate pred);

  /**
   * Converts a chain of when-then expressions (a list of {@link CqnCaseExpression.Case cases}) to a
   * {@link CqnCaseExpression case expression}, which returns a given default value if no condition
   * of any case matches.
   *
   * @param defaultValue the default value
   * @return the case expression
   * @see #when(CqnPredicate)
   * @see CQL#when(CqnPredicate)
   * @see StructuredType#when(CqnPredicate)
   * @see When#then(CqnValue)
   */
  <T extends Value<?> & CqnCaseExpression> T orElse(CqnValue defaultValue);

  /**
   * Converts a chain of when-then expressions (a list of {@link CqnCaseExpression.Case cases}) to a
   * {@link CqnCaseExpression case expression}, which returns a given default value if no condition
   * of any case matches.
   *
   * @param defaultValue the default value
   * @return the case expression
   * @see #when(CqnPredicate)
   * @see CQL#when(CqnPredicate)
   * @see StructuredType#when(CqnPredicate)
   * @see When#then(CqnValue)
   */
  <T extends Value<?> & CqnCaseExpression> T orElse(Object defaultValue);
}
