/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public interface CqnArithmeticExpression extends CqnExpression {

  CqnValue left();

  CqnValue right();

  Operator operator();

  @Override
  default boolean isArithmeticExpression() {
    return true;
  }

  @Override
  default CqnArithmeticExpression asArithmeticExpression() {
    return this;
  }

  @Override
  default void accept(CqnVisitor visitor) {
    left().accept(visitor);
    right().accept(visitor);

    visitor.visit(this);
  }

  public enum Operator {

    /** Addition operator */
    ADD("+"),

    /** Subtraction operator */
    SUB("-"),

    /** Multiplication operator */
    MUL("*"),

    /** Division operator */
    DIV("/");

    private final String symbol;

    private Operator(String op) {
      this.symbol = op;
    }

    public String symbol() {
      return symbol;
    }
  }
}
