/*
 * © 2018-2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.stream.Stream;

public interface CqnElementRef extends CqnReference, CqnValue, CqnSelectListValue {

  String $KEY = "$key";

  @Override
  default boolean isRef() {
    return true;
  }

  @Override
  default CqnElementRef asRef() {
    return this;
  }

  @Override
  default Stream<CqnElementRef> ofRef() {
    return Stream.of(this);
  }

  @Override
  default boolean isValue() {
    return true;
  }

  @Override
  default CqnValue value() {
    return this;
  }

  /**
   * Dispatches the handling of this {@code CqnElementRef} to a given visitor.
   *
   * <p>Neither the segments of this reference nor the segments' filters are traversed.
   *
   * @param visitor the {@link CqnVisitor}
   */
  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }

  @Override
  default CqnSelectListValue asValue() {
    return this;
  }
}
