/*
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnExpand extends CqnSelectList, CqnEntitySelector {

  String displayName();

  default Optional<String> alias() {
    return ref().alias();
  }

  @Override
  default boolean isExpand() {
    return true;
  }

  @Override
  default CqnExpand asExpand() {
    return this;
  }

  /**
   * Dispatches the handling of this {@code CqnExpand expand specification} to a given visitor.
   *
   * <p>Neither the {@link #ref() ref} nor the {@link #items() items} or the {@link #orderBy() order
   * by clause} of the expand specification are traversed.
   *
   * @param visitor the {@link CqnVisitor}
   */
  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
