/*
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnFilterableStatement extends CqnStatement {

  /**
   * The where clause of the filterable statement as a {@link CqnPredicate}.
   *
   * @return a reference to the statement's where clause as a {@link CqnPredicate} wrapped in an
   *     {@link Optional}
   */
  Optional<CqnPredicate> where();
}
