/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public interface CqnInline extends CqnSelectList {

  @Override
  default boolean isInline() {
    return true;
  }

  @Override
  default CqnInline asInline() {
    return this;
  }

  /**
   * Dispatches the handling of this {@code CqnInline inline specification} to a given visitor.
   *
   * <p>Neither the {@link #ref() ref} nor the {@link #items() items} of this inline specification
   * are traversed.
   *
   * @param visitor the {@link CqnVisitor}
   */
  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
