/*
 * © 2018-2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Map;

public interface CqnInsert extends CqnXsert {

  /**
   * The entries to be inserted by this statement.
   *
   * @return a reference to the insert statement's entries
   */
  @Override
  List<Map<String, Object>> entries();

  @Override
  default boolean isInsert() {
    return true;
  }

  @Override
  default CqnInsert asInsert() {
    return this;
  }
}
