/*
 * © 2019-2022 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import com.sap.cds.JSONizable;
import java.util.Optional;

public interface CqnLock extends JSONizable {

  Optional<Integer> timeout();

  Mode mode();

  enum Mode {
    EXCLUSIVE("forUpdate"),
    SHARED("forShareLock");

    private final String csn;

    Mode(String csn) {
      this.csn = csn;
    }

    public String csn() {
      return csn;
    }
  }
}
