/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public interface CqnPlain extends CqnValue {

  /**
   * Returns the name plain value.
   *
   * @return the plain value
   */
  String plain();

  @Override
  default boolean isPlain() {
    return true;
  }

  @Override
  default CqnPlain asPlain() {
    return this;
  }

  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
