/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.Iterator;

public interface Path extends Iterable<ResolvedSegment> {

  /**
   * Returns an iterator over {@link ResolvedSegment ResolvedSegment(s)}.
   *
   * @return an Iterator
   */
  @Override
  Iterator<ResolvedSegment> iterator();

  /**
   * Returns a reverse order iterator over {@link ResolvedSegment ResolvedSegment(s)}, starting from
   * the target segment.
   *
   * @return an Iterator
   */
  Iterator<ResolvedSegment> reverse();

  /**
   * Returns the root segment of the path.
   *
   * @return the root segment
   */
  ResolvedSegment root();

  /**
   * Returns the target segment of the path.
   *
   * @return the target segment
   */
  ResolvedSegment target();

  /**
   * Converts this path to a {@link CqnReference}.
   *
   * @return this path as ref
   */
  CqnReference toRef();
}
