/*
 * © 2018-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnToken;
import java.util.Map;

@Beta
public interface CqnCustomTransformation extends CqnTransformation {

  String name();

  Map<String, CqnToken> parameters();

  @Override
  default Kind kind() {
    return Kind.CUSTOM;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
