/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;

/** Transformation that filters the input set */
@Beta
public interface CqnFilterTransformation extends CqnTransformation {

  /**
   * The filter to apply to the input set
   *
   * @return the filter to apply to the input set
   */
  CqnPredicate filter();

  @Override
  default Kind kind() {
    return Kind.FILTER;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
