/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;

/** Transformation that filters the input set with a search expression */
@Beta
public interface CqnSearchTransformation extends CqnTransformation {

  /**
   * The search expression to filter the input set with
   *
   * @return the search expression
   */
  CqnPredicate search();

  @Override
  default Kind kind() {
    return Kind.SEARCH;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
