/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.JSONizable;
import com.sap.cds.reflect.CdsStructuredType;

/** A transformation that is applied to the input set to produce an output set. */
@Beta
public interface CqnTransformation extends JSONizable {

  enum Kind {
    IDENTITY,
    FILTER,
    SEARCH,
    AGGREGATE,
    COMPUTE,
    GROUPBY,
    ORDERBY,
    SKIP,
    TOP,
    CUSTOM,
    ANCESTORS,
    DESCENDANTS,
    TOPLEVELS;
  }

  /**
   * Returns the kind of this transformation
   *
   * @return the kind of this transformation
   */
  Kind kind();

  CqnTransformation IDENTITY =
      new CqnTransformation() {

        @Override
        public Kind kind() {
          return Kind.IDENTITY;
        }

        @Override
        public void accept(CqnTransformationVisitor visitor) {}
      };

  default CdsStructuredType rowType(CdsStructuredType in) {
    return in;
  }

  @Override
  default String toJson() {
    return kind().toString();
  }

  default void accept(CqnTransformationVisitor visitor) {
    throw new UnsupportedOperationException("Unimplemented method 'accept'");
  }
}
