/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.hana;

import com.google.common.annotations.Beta;
import com.sap.cds.CqnTableFunction;

/** */
@Beta
public interface CqnHierarchy extends CqnTableFunction {

  @Override
  default boolean isTableFunction() {
    return true;
  }

  @Override
  default CqnHierarchy asTableFunction() {
    return this;
  }

  default boolean isHierarchySubset() {
    return false;
  }

  default CqnHierarchySubset asHierarchySubset() {
    throw new ClassCastException("Cannot cast to CqnHierarchySubset");
  }

  default boolean isGenerator() {
    return false;
  }

  default CqnHierarchyGenerator asGenerator() {
    throw new ClassCastException("Cannot cast to CqnHierarchyGenerator");
  }
}
