/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

public interface CdsAction extends CdsOperation {

  @Override
  default CdsKind getKind() {
    return CdsKind.ACTION;
  }

  @Override
  default void accept(CdsVisitor visitor) {
    parameters().forEach(e -> e.accept(visitor));

    visitor.visit(this);
  }
}
