/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

public interface CdsElement extends CdsElementDefinition {

  /**
   * Returns the fully qualified name of this element.
   *
   * @return the fully qualified name
   */
  default String getQualifiedName() {
    return getDeclaringType().getQualifiedName() + ":" + getName();
  }

  /**
   * Returns the declaring type of this {@code CdsElement}.
   *
   * @param <T> the type of the declaring type
   * @return the declaring type of this element, not {@code null}
   */
  <T extends CdsDefinition> T getDeclaringType();

  /**
   * Accepts a {@link CdsVisitor} visiting this type.
   *
   * @param visitor the {@code CdsVisitor}
   */
  default void accept(CdsVisitor visitor) {
    visitor.visit(this);
  }
}
