/*
 * © 2019-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

import java.util.Map;

public interface CdsEnumType<T> extends CdsSimpleType {

  /**
   * Returns the enumerals of this {@code CdsEnumType} as a map, which maps the name of the enumeral
   * to the enumeral.
   *
   * @return the enumerals of this enum type, not {@code null}
   * @see Enumeral
   */
  Map<String, Enumeral<T>> enumerals();

  /**
   * Tests if this enum type has an enumeral with a given value.
   *
   * @param value the value to test for
   * @return {@code true} if this enum type has an enumeral with a given value, {@code false}
   *     otherwise
   */
  default boolean hasValue(Object value) {
    return enumerals().values().stream().anyMatch(e -> e.value().equals(value));
  }

  @Override
  default boolean isEnum() {
    return true;
  }

  @Override
  default void accept(CdsVisitor visitor) {
    visitor.visit(this);
  }

  interface Enumeral<T> extends CdsAnnotatable {
    /**
     * Returns the name of this enumeral.
     *
     * @return the name, not {@code null}
     */
    String name();

    /**
     * Returns the value of this enumeral.
     *
     * @return the value, not {@code null}
     */
    T value();
  }
}
