/*
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

public interface CdsEvent extends CdsStructuredType {

  @Override
  default CdsKind getKind() {
    return CdsKind.EVENT;
  }

  @Override
  default void accept(CdsVisitor visitor) {
    elements().forEach(e -> e.accept(visitor));

    visitor.visit(this);
  }
}
