/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

import java.io.Serial;

/**
 * Indicates that a {@link CdsEntity} doesn't have an operation (action or function) with a
 * specified name.
 */
public class CdsOperationNotFoundException extends CdsReflectiveOperationException {

  @Serial private static final long serialVersionUID = 1L;
  private final String operationName;
  private final transient CdsDefinition definition;
  private final CdsKind kind;

  public CdsOperationNotFoundException(
      CdsKind kind, String operationName, CdsDefinition definition) {
    super(
        "No %s with name '%s' in '%s'"
            .formatted(kind, operationName, definition.getQualifiedName()));
    this.definition = definition;
    this.operationName = operationName;
    this.kind = kind;
  }

  /**
   * Get the missing operation
   *
   * @return operation name
   */
  public String getOperationName() {
    return operationName;
  }

  /**
   * Get the definition for which the operation was requested
   *
   * @return definition
   */
  public CdsDefinition getDefinition() {
    return definition;
  }

  /**
   * Get the operation kind
   *
   * @return operation kind {@link CdsKind}
   */
  public CdsKind getKind() {
    return kind;
  }
}
