/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.transaction;

import java.io.Serial;

/**
 * An exception indicating that an operation required an active transaction but no transaction is
 * active
 */
public class TransactionRequiredException extends TransactionException {

  public TransactionRequiredException(String msg) {
    super(msg);
  }

  public TransactionRequiredException() {
    super("There is no currently active transaction");
  }

  @Serial private static final long serialVersionUID = 1L;
}
