/*
 * © 2018-2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.transaction.spi;

import com.sap.cds.transaction.RollbackException;
import com.sap.cds.transaction.TransactionManager;
import com.sap.cds.transaction.TransactionRequiredException;

/**
 * A ContainerTransactionManager is a thread-safe API that allows to manage transactions of an
 * underlying data source.
 */
public interface ContainerTransactionManager extends TransactionManager {

  /** Start a transaction on the managed data source */
  void begin();

  /**
   * If there is an active transaction commit it.
   *
   * @throws TransactionRequiredException if there is no active transaction
   * @throws RollbackException if the transaction has been rolled back
   */
  void commit();

  /**
   * If there is an active transaction roll it back.
   *
   * @throws TransactionRequiredException if there is no active transaction
   */
  void rollback();

  /**
   * True, if the transaction manager was marked for rollback only for the currently active
   * transaction
   *
   * @return true if {@link #setRollbackOnly()} was called for the transaction, false otherwise
   */
  boolean isRollbackOnly();
}
