/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsEntity;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UniqueConstraintException
extends CdsDataException {
    private static final long serialVersionUID = 1L;
    private final transient CdsEntity entity;
    private final transient Map<String, Object> elementValues;

    public UniqueConstraintException(CdsEntity entity, Map<String, Object> elementValues, Set<String> keys, Exception ex) {
        super("Unique constraint violated when inserting or updating '%s[%s]'".formatted(entity.getQualifiedName(), UniqueConstraintException.stringify(elementValues, keys)), ex);
        this.entity = entity;
        this.elementValues = elementValues;
    }

    public String getEntityName() {
        return this.entity.getQualifiedName();
    }

    public Map<String, Object> getElementValues() {
        return this.elementValues;
    }

    private static String stringify(Map<String, Object> values, Set<String> keys) {
        return values.entrySet().stream().map(k -> (String)k.getKey() + (String)(keys.contains(k.getKey()) ? "=" + k.getValue() : "")).collect(Collectors.joining(", "));
    }
}

