/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.cqn;

import com.sap.cds.JSONizable;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CqnReference
extends CqnToken {
    public List<Segment> segments();

    default public Stream<Segment> stream() {
        return this.segments().stream();
    }

    default public String path() {
        return this.stream().map(Segment::id).collect(Collectors.joining("."));
    }

    default public int size() {
        return this.segments().size();
    }

    public Optional<String> alias();

    default public Segment rootSegment() {
        return this.segments().get(0);
    }

    default public Segment targetSegment() {
        return this.segments().get(this.size() - 1);
    }

    default public String firstSegment() {
        return this.rootSegment().id();
    }

    default public String lastSegment() {
        return this.targetSegment().id();
    }

    public static interface Segment
    extends JSONizable {
        public Optional<CqnPredicate> filter();

        public String id();
    }
}

