/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CDS;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.NullValue;
import com.sap.cds.ql.Parameter;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Then;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.When;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.ql.cqn.Modifier;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;

public interface CQL {
    public static final BooleanValue TRUE = CDS.QL.create.booleanValue(true);
    public static final BooleanValue FALSE = CDS.QL.create.booleanValue(false);
    public static final NullValue NULL = CDS.QL.create.nullValue();

    public static RefBuilder<StructuredTypeRef> copy(CqnStructuredTypeRef ref) {
        return CDS.QL.builder.copy(ref);
    }

    public static RefBuilder<ElementRef<?>> copy(CqnElementRef ref) {
        return CDS.QL.builder.copy(ref);
    }

    public static Expand<?> copy(CqnExpand expand) {
        return CDS.QL.builder.copy(expand);
    }

    public static Predicate copy(CqnPredicate pred) {
        return CDS.QL.builder.copy(pred);
    }

    public static Predicate copy(CqnPredicate pred, Modifier modifier) {
        return CDS.QL.builder.copy(pred, modifier);
    }

    public static <S extends CqnStatement> S copy(S statement) {
        return (S)CDS.QL.builder.copy(statement);
    }

    public static <S extends CqnStatement> S copy(S statement, Modifier modifier) {
        return (S)CDS.QL.builder.copy(statement, modifier);
    }

    public static <T> FunctionCall<T> func(String name, CqnValue ... args) {
        return CQL.func(name, Arrays.asList(args));
    }

    public static <T> FunctionCall<T> func(String name, List<? extends CqnValue> args) {
        return CDS.QL.create.func(name, args);
    }

    public static BooleanFunction booleanFunc(String name, List<? extends CqnValue> args) {
        return CDS.QL.create.booleanFunc(name, args);
    }

    public static <T> Literal<T> constant(T value) {
        return CDS.QL.create.constant(value);
    }

    public static <T> Literal<T> val(T value) {
        return CDS.QL.create.val(value);
    }

    @Beta
    public static CqnVector vector(Object vector) {
        return CDS.QL.create.vector(vector);
    }

    public static Predicate not(CqnPredicate predicate) {
        return CDS.QL.create.not(predicate);
    }

    public static Predicate and(CqnPredicate p1, CqnPredicate p2) {
        return CQL.and(Arrays.asList(p1, p2));
    }

    public static Collector<CqnPredicate, ?, CqnPredicate> withAnd() {
        return CDS.QL.create.withAnd();
    }

    public static Predicate or(CqnPredicate p1, CqnPredicate p2) {
        return CQL.or(Arrays.asList(p1, p2));
    }

    public static Predicate and(Iterable<? extends CqnPredicate> predicates) {
        return CQL.connect(CqnConnectivePredicate.Operator.AND, predicates);
    }

    public static Predicate or(Iterable<? extends CqnPredicate> predicates) {
        return CQL.connect(CqnConnectivePredicate.Operator.OR, predicates);
    }

    public static Collector<CqnPredicate, ?, CqnPredicate> withOr() {
        return CDS.QL.create.withOr();
    }

    public static Predicate connect(CqnConnectivePredicate.Operator operator, Iterable<? extends CqnPredicate> predicates) {
        return CDS.QL.create.connect(operator, predicates);
    }

    public static <T> Parameter<T> param(int index) {
        return CQL.param(String.valueOf(index));
    }

    public static <T> Parameter<T> param(String name) {
        return CDS.QL.create.param(name);
    }

    public static Value<?> plain(String value) {
        return CDS.QL.create.plain(value);
    }

    public static Value<Long> count() {
        return CQL.func("COUNT", new CqnValue[0]);
    }

    public static Value<Long> count(CqnElementRef element) {
        return CQL.func("COUNT", element);
    }

    public static <T> Value<T> min(CqnValue value) {
        return CQL.func("min", value);
    }

    public static <T> Value<T> max(CqnValue value) {
        return CQL.func("max", value);
    }

    public static Value<Number> sum(CqnValue value) {
        return CQL.func("sum", value);
    }

    public static Value<Number> average(CqnValue value) {
        return CQL.func("avg", value);
    }

    public static Value<Long> countDistinct(CqnValue value) {
        return CDS.QL.create.countDistinct(value);
    }

    public static Predicate contains(CqnValue value, CqnValue substring, boolean caseInsensitive) {
        return CDS.QL.create.containment(CqnContainmentTest.Position.ANY, value, substring, caseInsensitive);
    }

    public static Predicate startsWith(CqnValue value, CqnValue prefix, boolean caseInsensitive) {
        return CDS.QL.create.containment(CqnContainmentTest.Position.START, value, prefix, caseInsensitive);
    }

    public static Predicate endsWith(CqnValue value, CqnValue suffix, boolean caseInsensitive) {
        return CDS.QL.create.containment(CqnContainmentTest.Position.END, value, suffix, caseInsensitive);
    }

    public static Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue substring, boolean caseInsensitive) {
        return CDS.QL.create.containment(position, value, substring, caseInsensitive);
    }

    public static Value<String> toLower(Value<String> val) {
        return CDS.QL.create.toLower(val);
    }

    public static Value<String> toLower(String val) {
        return CDS.QL.create.toLower(CQL.val(val));
    }

    public static Value<String> toUpper(Value<String> val) {
        return CDS.QL.create.toUpper(val);
    }

    public static Value<String> toUpper(String val) {
        return CDS.QL.create.toUpper(CQL.val(val));
    }

    public static Value<Double> cosineSimilarity(CqnValue vector1, CqnValue vector2) {
        return CDS.QL.create.cosineSimilarity(vector1, vector2);
    }

    public static Value<Double> l2Distance(CqnValue vector1, CqnValue vector2) {
        return CDS.QL.create.l2Distance(vector1, vector2);
    }

    public static StructuredType<?> entity(String qualifiedName) {
        return CDS.QL.create.entity(qualifiedName);
    }

    public static <T extends StructuredType<T>> T entity(Class<T> type) {
        return CDS.QL.create.entity(type);
    }

    public static StructuredType<?> to(String path) {
        return CDS.QL.create.to(path);
    }

    public static StructuredType<?> to(List<? extends CqnReference.Segment> segments) {
        return CDS.QL.create.to(segments);
    }

    public static <T> ElementRef<T> get(String path) {
        return CDS.QL.create.get(path);
    }

    public static <T> ElementRef<T> get(List<? extends CqnReference.Segment> segments) {
        return CDS.QL.create.get(segments);
    }

    public static CqnReference.Segment refSegment(String id) {
        return CDS.QL.create.refSegment(id);
    }

    public static CqnReference.Segment refSegment(String id, CqnPredicate filter) {
        return CDS.QL.create.refSegment(id, filter);
    }

    public static List<CqnReference.Segment> refSegments(List<String> segmentIds) {
        return CDS.QL.create.refSegments(segmentIds);
    }

    public static Value<Number> expression(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right) {
        return CDS.QL.create.expression(left, op, right);
    }

    public static Predicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs) {
        return CDS.QL.create.comparison(lhs, op, rhs);
    }

    public static Predicate in(CqnValue value, Collection<? extends CqnValue> values) {
        return CDS.QL.create.in(value, values);
    }

    public static Predicate between(CqnValue value, CqnValue low, CqnValue high) {
        return CDS.QL.create.between(value, low, high);
    }

    public static Predicate in(CqnValue value, CqnValue valueSet) {
        return CDS.QL.create.in(value, valueSet);
    }

    public static Predicate in(List<String> elements, Collection<? extends Map<String, ?>> valueMaps) {
        return CDS.QL.create.in(elements, valueMaps);
    }

    public static Predicate in(CqnValue value, CqnSelect subquery) {
        return CDS.QL.create.in(value, subquery);
    }

    @Beta
    public static Predicate eTag(CqnListValue values) {
        return CDS.QL.create.eTag(values);
    }

    @Beta
    public static Predicate eTag(Object value) {
        return CQL.eTag(CQL.list(CQL.val(value)));
    }

    @Beta
    public static Predicate eTag(CqnElementRef elementRef, Object value) {
        return CDS.QL.create.eTag(elementRef, value);
    }

    public static Predicate search(String term) {
        return CDS.QL.create.search(term);
    }

    public static Predicate exists(CqnSelect subQuery) {
        return CDS.QL.create.exists(subQuery);
    }

    public static Predicate match(CqnStructuredTypeRef ref, CqnPredicate pred, CqnMatchPredicate.Quantifier quantifier) {
        return CDS.QL.create.match(ref, pred, quantifier);
    }

    public static Value<Instant> now() {
        return CDS.QL.create.now().type(Instant.class);
    }

    public static Value<Instant> validFrom() {
        return CDS.QL.create.validFrom().type(Instant.class);
    }

    public static Value<Instant> validTo() {
        return CDS.QL.create.validTo().type(Instant.class);
    }

    public static Value<String> userLocale() {
        return CDS.QL.create.userLocale().type(String.class);
    }

    public static Value<String> userId() {
        return CDS.QL.create.userId().type(String.class);
    }

    public static CqnStar star() {
        return CqnStar.star();
    }

    public static CqnListValue list(List<? extends CqnValue> values) {
        return CDS.QL.create.list(values);
    }

    public static CqnListValue list(CqnValue ... values) {
        return CQL.list(Arrays.asList(values));
    }

    public static Predicate matching(Map<String, ?> elementToValueMap) {
        return CDS.QL.builder.matching(elementToValueMap);
    }

    public static CqnSortSpecification sort(CqnValue value, CqnSortSpecification.Order order) {
        return CDS.QL.create.sort(value, order);
    }

    public static Predicate matchesPattern(CqnValue value, CqnValue pattern, CqnValue options) {
        return CDS.QL.create.matchesPattern(value, pattern, options);
    }

    public static Predicate matchesPattern(CqnValue value, CqnValue pattern) {
        return CDS.QL.create.matchesPattern(value, pattern);
    }

    public static Predicate matchesPattern(CqnValue value, String pattern) {
        return CDS.QL.create.matchesPattern(value, CQL.val(pattern));
    }

    public static Predicate matchesPattern(CqnValue value, CqnValue pattern, boolean caseInsensitive, boolean multiLineSensitive) {
        return CDS.QL.create.matchesPattern(value, pattern, caseInsensitive, multiLineSensitive);
    }

    public static When when(CqnPredicate pred) {
        return CDS.QL.create.when(pred);
    }

    public static Then cases() {
        return CDS.QL.create;
    }
}

