/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnCaseExpression;
import com.sap.cds.ql.cqn.CqnValue;

public interface When {

	/**
	 * Specifies the return value of a {@link CqnCaseExpression.Case case}.
	 * @param value the return value
	 * 
	 * @return a builder to connect more cases or to specify the default value
	 */
	Then then(CqnValue value);

	/**
	 * Specifies the return value of a {@link CqnCaseExpression.Case case}.
	 * @param value the return value
	 * 
	 * @return a builder to connect more cases or to specify the default value
	 */
	Then then(Object value);

}
