/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.sap.cds.JSONizable;

public interface CqnReference extends CqnToken {

	/**
	 * Returns the segments of this ref.
	 *
	 * @return the ref segments
	 */
	List<Segment> segments();

	default Stream<Segment> stream() {
		return segments().stream();
	}

	default String path() {
		return stream().map(Segment::id).collect(Collectors.joining("."));
	}

	default int size() {
		return segments().size();
	}

	Optional<String> alias();

	/**
	 * Returns the first segment of this ref.
	 *
	 * @return the first segment
	 */
	default Segment rootSegment() {
		return segments().get(0);
	}

	/**
	 * Returns the last segment of this ref.
	 *
	 * @return the last segment
	 */
	default Segment targetSegment() {
		return segments().get(size() - 1);
	}

	default String firstSegment() {
		return rootSegment().id();
	}

	default String lastSegment() {
		return targetSegment().id();
	}

	interface Segment extends JSONizable {

		Optional<CqnPredicate> filter();

		String id();

	}

}
