/************************************************************************
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn.transformation;

import java.util.Map;

import com.google.common.annotations.Beta;

/**
 * Transformation that determines top level instances that belong to a recursive
 * hierarchy.
 * 
 * The hierarchy is defined by the {@link #hierarchyReference() hierarchy
 * reference} and the {@link #hierarchyQualifier() hierarchy qualifier}.
 * 
 * The transformation takes an input set consisting of instances that belong to
 * the hierarchy. The output retains nodes of the top <i>n</i> {@link levels},
 * i.e. nodes with less then <i>n</i> ancestors.
 */
@Beta
public interface CqnTopLevelsTransformation extends CqnHierarchyTransformation {

	/**
	 * Returns the number of levels, which the output set should contain
	 * 
	 * @return the number of levels or -1 if unlimited
	 */
	long levels();

	/**
	 * Returns nodes to be expanded
	 * 
	 * The expand levels are represented as a map. Identifier of a node to be
	 * expanded mapped to number of levels to be expanded. {@code null} means all
	 * levels, 0 means collapsed.
	 * 
	 * @return a map that relates the node ID to the required expand level
	 */
	public Map<Object, Long> expandLevels();

	@Override
	default Kind kind() {
		return Kind.TOPLEVELS;
	}
}
