/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

public interface CdsAnnotation<T> extends CdsNamed {

	/**
	 * Returns the name of this {@code CdsAnnotation}.
	 * 
	 * @return the items name of this annotation, not {@code null}
	 */
	String getName();

	/**
	 * Returns the value of this {@code CdsAnnotation}.
	 * 
	 * @return the value of this annotation, not {@code null}
	 */
	T getValue();

	@Override
	default String getKey() {
		return getName();
	}

}
