/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.reflect;

public interface CdsFunction extends CdsOperation {

	/**
	 * Returns the return type of this {@code CdsFunction}.
	 * 
	 * @return the return type of this function, not {@code null}
	 */
	@SuppressWarnings("OptionalGetWithoutIsPresent")
	default CdsType getReturnType() {
		return returnType().get();
	}

	@Override
	default CdsKind getKind() {
		return CdsKind.FUNCTION;
	}

	@Override
	default void accept(CdsVisitor visitor) {
		parameters().forEach(e -> e.accept(visitor));

		visitor.visit(this);
	}

}
