/*********************************************************************
 * (C) 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.reflect.overlay;

import com.google.common.annotations.Beta;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsModel;

/**
 * The {@code CdsModelExtender} allows to extend the underlying
 * {@link CdsModel}.
 */
@Beta
public interface CdsModelExtender {

	CdsModelExtender.Factory factory = Cds4jServiceLoader.load(CdsModelExtender.Factory.class);

	/**
	 * Creates a new {@link CdsModelExtender} for the given model.
	 *
	 * @param model the model to extend
	 * @return the model extender
	 */
	static CdsModelExtender extend(CdsModel model) {
		return factory.create(model);
	}

	/**
	 * Extends an entity with the given name. If the entity does not exist in the
	 * model, a {@link CdsDefinitionNotFoundException} exception is thrown.
	 *
	 * @param qualifiedName the qualified name of the entity to extend
	 * @return the entity extension builder
	 * @throws CdsDefinitionNotFoundException if the entity does not exist in the
	 *                                        model
	 */
	CdsEntityExtender entity(String qualifiedName);

	/**
	 * Builds the overlaid model with all its extensions.
	 *
	 * @return the overlaid model
	 */
	CdsModel build();

	/**
	 * The factory to create {@link CdsModelExtender} instances.
	 */
	interface Factory {
		CdsModelExtender create(CdsModel model);
	}

}
