/************************************************************************
 * © 2021-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.stream.Stream;

public interface CqnListValue extends CqnValue {

	Stream<CqnValue> values();

	int size();

	@Override
	default boolean isList() {
		return true;
	}

	@Override
	default CqnListValue asList() {
		return this;
	}

	@Override
	default void accept(CqnVisitor visitor) {
		values().forEach(t -> t.accept(visitor));

		visitor.visit(this);
	}
}
