/************************************************************************
 * © 2020-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;

public interface CqnSelectList extends CqnSelectListItem {

	CqnStructuredTypeRef ref();

	List<CqnSelectListItem> items();

	@Override
	default boolean isSelectList() {
		return true;
	}

	default boolean isInline() {
		return false;
	}

	@Override
	default boolean isExpand() {
		return false;
	}

	@Override
	default CqnSelectList asSelectList() {
		return this;
	}

	default CqnInline asInline() {
		throw new ClassCastException("Cannot cast to CqnInline");
	}

	@Override
	default CqnExpand asExpand() {
		throw new ClassCastException("Cannot cast to CqnExpand");
	}

}
