/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;

public interface CqnXsert extends CqnStatement {

	List<Map<String, Object>> entries();

	/**
	 * @deprecated instead use {@link #elements(CdsEntity)}
	 */
	@Deprecated
	Stream<String> elements();

	/**
	 * The elements to be xserted by the statement.
	 * 
	 * @param target the target entity
	 * 
	 * @return a stream of the elements to be xserted
	 */
	Stream<String> elements(CdsStructuredType target);

}
