/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;

public interface CqnHierarchyTransformation extends CqnTransformation {

	/**
	 * Returns a reference, which identifies the entities that form a recursive
	 * hierarchy. The entity is annotated with {@code RecursiveHierarchy} with a
	 * qualifier whose value is given by the {@link #hierarchyQualifier()} method.
	 * 
	 * @return a reference, which identifies the entities that form a recursive
	 *         hierarchy
	 */
	CqnStructuredTypeRef hierarchyReference();

	/**
	 * Returns the qualifier of the {@code RecursiveHierarchy} annotation
	 * 
	 * @return the hierarchy qualifier
	 */
	String hierarchyQualifier();

	/**
	 * Returns a reference to the property that identifies the nodes of the
	 * hierarchy.
	 * 
	 * @return a reference to the node property
	 */
	CqnElementRef nodeProperty();

}
