/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;

/**
 * Transformation that skips the first rows of the input set
 */
@Beta
public interface CqnSkipTransformation extends CqnTransformation {

	/**
	 * Returns the number of rows to be skipped
	 * 
	 * @return the number of rows to be skipped
	 */
	long skip();

	@Override
	default Kind kind() {
		return Kind.SKIP;
	}
}
