/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.reflect;

import java.util.stream.Stream;

public interface CdsService extends CdsDefinition {

	/**
	 * Returns a sequential {@code Stream} over all {@link CdsEvent} definitions in
	 * this service.
	 *
	 * @return a sequential {@code Stream} over the {@link CdsEvent} definitions
	 */
	Stream<CdsEvent> events();

	/**
	 * Returns a sequential {@code Stream} over all {@link CdsEntity} definitions in
	 * this service.
	 *
	 * @return a sequential {@code Stream} over the {@link CdsEntity} definitions
	 */
	Stream<CdsEntity> entities();

	/**
	 * Returns a sequential {@code Stream} over all {@link CdsFunction} definitions
	 * in this service.
	 *
	 * @return a sequential {@code Stream} over the {@link CdsFunction} definitions
	 */
	Stream<CdsFunction> functions();

	/**
	 * Returns a sequential {@code Stream} over all {@link CdsAction} definitions in
	 * this service.
	 *
	 * @return a sequential {@code Stream} over the {@link CdsAction} definitions
	 */
	Stream<CdsAction> actions();

	@Override
	default CdsKind getKind() {
		return CdsKind.SERVICE;
	}

	@Override
	default void accept(CdsVisitor visitor) {
		visitor.visit(this);
	}

}
