/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.reflect.CdsStructuredType;

@Beta
public interface CqnTableFunction extends CqnSource {
	@Override
	default boolean isTableFunction() {
		return true;
	}

	@Override
	default CqnTableFunction asTableFunction() {
		return this;
	}

	String name();
	
	CqnSource source();
	
	CdsStructuredType rowType(CdsStructuredType sourceRowType);
	
}
