/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds;

import static java.util.Objects.isNull;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class UserContext {

	private String id;
	private Locale locale;
	private TimeZone timeZone = TimeZone.getDefault();
	private String tenant;
	private Map<String, List<String>> attributes = new HashMap<>();

	private UserContext() {
	}

	public static UserContext create() {
		return new UserContext();
	}

	public UserContext from(UserContext userCtx) {
		setId(userCtx.getId());
		setLocale(userCtx.getLocale());
		setTenant(userCtx.getTenant());
		setAttributes(userCtx.getAttributes());
		return this;
	}

	public UserContext setId(String id) {
		this.id = id;
		return this;
	}

	public UserContext setLocale(Locale locale) {
		this.locale = locale;
		return this;
	}

	public UserContext setTimeZone(TimeZone timeZone) {
		this.timeZone = timeZone;
		return this;
	}

	public UserContext setTenant(String tenant) {
		this.tenant = tenant;
		return this;
	}

	public UserContext setAttributes(Map<String, List<String>> attributes) {
		if (isNull(attributes)) {
			this.attributes = new HashMap<>();
		} else {
			this.attributes = attributes;
		}

		return this;
	}

	public String getId() {
		return id;
	}

	public Locale getLocale() {
		return locale;
	}

	public TimeZone getTimeZone() {
		return timeZone;
	}

	public String getTenant() {
		return tenant;
	}

	public Map<String, List<String>> getAttributes() {
		return attributes;
	}

	public List<String> getAttribute(String name) {
		return attributes.get(name);
	}
}
