/************************************************************************
 * © 2019-2025 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate.Operator;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnMatchPredicate.Quantifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference.Segment;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSortSpecification.Order;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsEntity;

/**
 * Service Provider Interface
 */
public interface CqnBuilder {

	static CqnBuilder instance() {
		return CDS.QL.builder;
	}

	Select<StructuredType<?>> select(String entityName);

	Select<StructuredType<?>> select(String entityName, UnaryOperator<StructuredType<?>> path);

	Select<StructuredType<?>> select(CqnSource source);

	Insert insert(String entityName, UnaryOperator<StructuredType<?>> path);

	Upsert upsert(String entityName, UnaryOperator<StructuredType<?>> path);

	Update<StructuredType<?>> update(String entityName, UnaryOperator<StructuredType<?>> path);

	Delete<StructuredType<?>> delete(String entityName, UnaryOperator<StructuredType<?>> path);

	Insert insert(CqnStructuredTypeRef ref);

	Upsert upsert(CqnStructuredTypeRef ref);

	Update<StructuredType<?>> update(CqnStructuredTypeRef ref);

	Delete<StructuredType<?>> delete(CqnStructuredTypeRef ref);

	Select<StructuredType<?>> select(CdsEntity entity);

	Select<StructuredType<?>> select(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Insert insert(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Upsert upsert(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Update<StructuredType<?>> update(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Delete<StructuredType<?>> delete(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	<E extends StructuredType<E>> Select<E> select(Class<E> entity);

	<E extends StructuredType<E>, R extends StructuredType<R>> Select<R> select(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>> Select<E> select(Source<E> source);

	<E extends StructuredType<?>> Insert insert(E entity);

	<E extends StructuredType<?>> Upsert upsert(E entity);

	<E extends StructuredType<?>> Update<E> update(E entity);

	<E extends StructuredType<?>> Delete<E> delete(E entity);

	<E extends StructuredType<E>, R extends StructuredType<R>> Insert insert(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Delete<R> delete(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Upsert upsert(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Update<R> update(Class<E> entity, Function<E, R> path);

	RefBuilder<StructuredTypeRef> copy(CqnStructuredTypeRef ref);

	RefBuilder<ElementRef<?>> copy(CqnElementRef ref);

	Expand<?> copy(CqnExpand expand);

	Predicate copy(CqnPredicate pred);

	Predicate copy(CqnPredicate pred, Modifier modifier);

	<S extends CqnStatement, R extends S> R copy(S statement);

	<S extends CqnStatement, R extends S> R copy(S statement, Modifier modifier);

	CqnParser parse();

	QueryBuilderSupport support();

	Predicate matching(Map<String, ?> keyValueMap);

	interface QueryBuilderSupport extends Then {

		Value<String> toLower(Value<String> val);

		Value<String> toUpper(Value<String> val);

		<T> Parameter<T> param(String name);

		Value<?> plain(String val);

		<T> FunctionCall<T> func(String functionName, Iterable<? extends CqnValue> args);

		BooleanFunction booleanFunc(String functionName, List<? extends CqnValue> args);

		CqnListValue list(List<? extends CqnValue> values);

		Predicate not(CqnPredicate p);

		Predicate connect(Operator operator, Iterable<? extends CqnPredicate> predicates);

		Collector<CqnPredicate, ?, CqnPredicate> withOr();

		Collector<CqnPredicate, ?, CqnPredicate> withAnd();

		StructuredType<?> entity(String qualifiedName);

		<T extends StructuredType<T>> T entity(Class<T> type, CqnStructuredTypeRef ref);

		StructuredType<?> to(String path);

		StructuredType<?> to(List<? extends Segment> segments);

		<T> ElementRef<T> get(String path);

		<T> ElementRef<T> get(List<? extends Segment> segments);

		Segment refSegment(String id);

		Segment refSegment(String id, CqnPredicate filter);

		List<Segment> refSegments(List<String> segmentIds);

		Value<Number> expression(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right);

		Predicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs);

		Predicate in(CqnValue lhs, Collection<? extends CqnValue> values);

		Predicate in(CqnValue lhs, CqnValue valueSet);

		Predicate in(List<String> refs, Collection<? extends Map<String, ?>> valueMaps);

		Predicate in(CqnValue value, CqnSelect subquery);

		Predicate between(CqnValue value, CqnValue low, CqnValue high);

		Predicate search(String term);

		Predicate exists(CqnSelect subQuery);

		Predicate match(CqnStructuredTypeRef ref, CqnPredicate pred, Quantifier quantifier);

		Value<Instant> now();

		Value<Instant> validFrom();

		Value<Instant> validTo();

		Value<String> userLocale();

		Value<String> userId();

		FunctionCall<Long> countDistinct(CqnValue value);

		Value<Double> cosineSimilarity(CqnValue vector1, CqnValue vector2);

		Value<Double> l2Distance(CqnValue vector1, CqnValue vector2);

		Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue term,
				boolean caseInsensitive);

		<T> Literal<T> constant(T value);

		<T> Literal<T> val(T value);

		CqnVector vector(Object vector);

		CqnSortSpecification sort(CqnValue value, Order order);

		BooleanValue booleanValue(boolean bool);

		NullValue nullValue();

		Predicate matchesPattern(CqnValue value, CqnValue pattern);

		Predicate matchesPattern(CqnValue value, CqnValue pattern, CqnValue options);

		Predicate matchesPattern(CqnValue value, CqnValue pattern, boolean caseInsensitive, boolean multilineSensitive);

		Predicate eTag(CqnListValue values);

		Predicate eTag(CqnValue ref, Object value);

		@Override
		When when(CqnPredicate when);
	}

}
