/*******************************************************************
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.util.List;

import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnWindowFunc;

public interface WindowFunctionCall<T> extends FunctionCall<T>, CqnWindowFunc {

	@Override
	<U> WindowFunctionCall<U> type(String cdsType);

	/**
	 * Sets the order by clause of the window specification of this window function
	 * call.
	 *
	 * @param sortSpecs the sort specifications
	 * @return a window with the given sort order
	 */
	<U> WindowFunctionCall<U> orderBy(CqnSortSpecification... sortSpecs);

	/**
	 * Sets the order by clause of the window specification of this window function
	 * call.
	 *
	 * @param sortSpecs the sort specifications
	 * @return a window with the given sort order
	 */
	<U> WindowFunctionCall<U> orderBy(List<CqnSortSpecification> sortSpecs);

	/**
	 * Sets the order by clause of the window specification of this window function
	 * call. The elements, identified by paths, are sorted in ascending order.
	 *
	 * @param paths the paths defining the sort order
	 * @return a window with the given sort order
	 */
	<U> WindowFunctionCall<U> orderBy(String... paths);

}
