/*******************************************************************
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;

import com.google.common.annotations.Beta;

/**
 * A window function call. A window function an only be executed on an SQL data store.
 */
@Beta
public interface CqnWindowFunc extends CqnFunc {

	/**
	 * Returns the window specification of this window function
	 * @return the window specification
	 */
	WindowSpecification window();

	@Beta
	/**
	 * The window specification of a window function
	 */
	interface WindowSpecification {

		/**
		 * Returns the partitions of this window specification
		 * 
		 * @return the partitions
		 */
		List<CqnValue> partitionBy();

		/**
		 * Returns the order of this window specification
		 * 
		 * @return the order
		 */
		List<CqnSortSpecification> orderBy();

	}

	@Override
	default void accept(CqnVisitor visitor) {
		args().forEach(a -> a.accept(visitor));
		window().partitionBy().forEach(p -> p.accept(visitor));
		window().orderBy().forEach(o -> o.accept(visitor));

		visitor.visit(this);
	}

}
